package javadoc;

import java.io.*;

/**
 * Very stupid, but well-documented class.
 *
 * This class is for education purposes only.
 *
 * @author Georgiy Korneev
 * @version 0.2
 */
public class JavadocExample3 {
    /** Default value for {@link #verySimpleMethod()}. */
    private final static int DEFAULT_VALUE = 10;

    /**
     * The stupid class may not have a smart constructor, isn't it?
     */
    public JavadocExample3() {
    }

    /**
     * But even a stupid class may have a simple constructor.
     *
     * @param a absolutely meaningless parameter.
     * @param b another absolutely meaningless parameter.
     */
    public JavadocExample3(final int a, final int b) {
    }

    /**
     * Performs a very complex computation. The computed value is ignored.
     *
     * @param level complexity level.
     * @param seed initial seed.
     *
     * @throws IOException if an I/O error occurred.
     *
     * @since 0.2
     * @see #verySimpleMethod
     */
    public void veryComplexMethod(final int level, final int seed) throws IOException {
        if (seed * level == 0) throw new IOException();
    }

    /**
     * Perform complex computation.
     *
     * @deprecated use {@link #veryComplexMethod brand-new very complex method}
     * instead.
     *
     * @param seed initial seed.
     */
    @Deprecated
    public void complexMethod(final int seed) {
    }

    /**
     * Just returns a default value. The default value is
     * {@value #DEFAULT_VALUE}.
     *
     * @return default value.
     */
    public int verySimpleMethod() {
        // The answer for the 3rd question will be ...
        return DEFAULT_VALUE;
    }
}
