import java.util.Arrays;
import java.util.Objects;

// Model: a[1]..a[n]
// Inv: n >= 0 && forall i=1..n: a[i] != null
// Let: immutable(k): forall i=1..k: a'[i] = a[i]
public class ArrayStackModule {
    private static int size;
    private static Object[] elements = new Object[5];

    // Pre: element != null
    // Post: n' = n + 1 &&
    //       a'[n'] = element &&
    //       immutable(n)
    public static void push(Object element) {
        Objects.requireNonNull(element);

        ensureCapacity(size + 1);
        elements[size++] = element;
    }

    // Pre: true
    // Post: n' = n && immutable(n)
    private static void ensureCapacity(int capacity) {
        if (capacity > elements.length) {
            elements = Arrays.copyOf(elements, 2 * capacity);
        }
    }

    // Pre: n > 0
    // Post: R = a[n] && n' = n - 1 && immutable(n')
    public static Object pop() {
        assert size > 0;

        return elements[--size];
    }

    // Pre: n > 0
    // Post: R = a[n] && n' = n && immutable(n)
    public static Object peek() {
        assert size > 0;

        return elements[size - 1];
    }

    // Pre: true
    // Post: R = n && n' = n && immutable(n)
    public static int size() {
        return size;
    }

    // Pre: true
    // Post: R = (n = 0) && n' = n && immutable(n)
    public static boolean isEmpty() {
        return size == 0;
    }
}
