/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTError;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.LightweightPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Properties;

public abstract class Toolkit {
    private static Toolkit toolkit;
    private static Object classLock;
    private static Properties properties;

    protected abstract ButtonPeer createButton(Button var1);

    protected abstract TextFieldPeer createTextField(TextField var1);

    protected abstract LabelPeer createLabel(Label var1);

    protected abstract ListPeer createList(List var1);

    protected abstract CheckboxPeer createCheckbox(Checkbox var1);

    protected abstract ScrollbarPeer createScrollbar(Scrollbar var1);

    protected abstract ScrollPanePeer createScrollPane(ScrollPane var1);

    protected abstract TextAreaPeer createTextArea(TextArea var1);

    protected abstract ChoicePeer createChoice(Choice var1);

    protected abstract FramePeer createFrame(Frame var1);

    protected abstract CanvasPeer createCanvas(Canvas var1);

    protected abstract PanelPeer createPanel(Panel var1);

    protected abstract WindowPeer createWindow(Window var1);

    protected abstract DialogPeer createDialog(Dialog var1);

    protected abstract MenuBarPeer createMenuBar(MenuBar var1);

    protected abstract MenuPeer createMenu(Menu var1);

    protected abstract PopupMenuPeer createPopupMenu(PopupMenu var1);

    protected abstract MenuItemPeer createMenuItem(MenuItem var1);

    protected abstract FileDialogPeer createFileDialog(FileDialog var1);

    protected abstract CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem var1);

    protected LightweightPeer createComponent(Component component) {
        return new java.awt.LightweightPeer(component);
    }

    protected abstract FontPeer getFontPeer(String var1, int var2);

    protected void loadSystemColors(int[] nArray) {
    }

    public abstract Dimension getScreenSize();

    public abstract int getScreenResolution();

    public abstract ColorModel getColorModel();

    public abstract String[] getFontList();

    public abstract FontMetrics getFontMetrics(Font var1);

    public abstract void sync();

    public static Toolkit getDefaultToolkit() {
        Object object = classLock;
        synchronized (object) {
            if (toolkit == null) {
                String string = System.getProperty("awt.toolkit", "sun.awt.motif.MToolkit");
                try {
                    toolkit = (Toolkit)Class.forName(string).newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new AWTError("Toolkit not found: " + string);
                }
                catch (InstantiationException instantiationException) {
                    throw new AWTError("Could not instantiate Toolkit: " + string);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new AWTError("Could not access Toolkit: " + string);
                }
            }
            Toolkit toolkit = Toolkit.toolkit;
            Object var2_3 = null;
            return toolkit;
        }
    }

    public abstract Image getImage(String var1);

    public abstract Image getImage(URL var1);

    public abstract boolean prepareImage(Image var1, int var2, int var3, ImageObserver var4);

    public abstract int checkImage(Image var1, int var2, int var3, ImageObserver var4);

    public abstract Image createImage(ImageProducer var1);

    public Image createImage(byte[] byArray) {
        return this.createImage(byArray, 0, byArray.length);
    }

    public abstract Image createImage(byte[] var1, int var2, int var3);

    public abstract PrintJob getPrintJob(Frame var1, String var2, Properties var3);

    public abstract void beep();

    public abstract Clipboard getSystemClipboard();

    public int getMenuShortcutKeyMask() {
        return 2;
    }

    protected static Container getNativeContainer(Component component) {
        return component.getNativeContainer();
    }

    public static String getProperty(String string, String string2) {
        String string3 = properties.getProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public final EventQueue getSystemEventQueue() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkAwtEventQueueAccess();
        }
        return this.getSystemEventQueueImpl();
    }

    protected abstract EventQueue getSystemEventQueueImpl();

    static EventQueue getEventQueue() {
        return toolkit.getSystemEventQueueImpl();
    }

    static {
        classLock = new Object();
        String string = File.separator;
        File file = new File(String.valueOf(System.getProperty("java.home")) + string + "lib" + string + "awt.properties");
        properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            properties.load(new BufferedInputStream(fileInputStream));
            fileInputStream.close();
        }
        catch (Exception exception) {}
    }
}

