/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteServer;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerCloneException;
import java.rmi.server.ServerRef;

public class UnicastRemoteObject
extends RemoteServer {
    private static final long serialVersionUID = 4974527148936298033L;

    protected UnicastRemoteObject() throws RemoteException {
        UnicastRemoteObject.exportObject(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        UnicastRemoteObject.exportObject(this);
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            UnicastRemoteObject unicastRemoteObject = (UnicastRemoteObject)super.clone();
            UnicastRemoteObject.exportObject(unicastRemoteObject);
            return unicastRemoteObject;
        }
        catch (RemoteException remoteException) {
            throw new ServerCloneException("Clone failed", remoteException);
        }
    }

    public static RemoteStub exportObject(Remote remote) throws RemoteException {
        try {
            Class clazz = Class.forName(String.valueOf(RemoteRef.packagePrefix) + ".UnicastServerRef");
            Object object = clazz.newInstance();
            if (object instanceof ServerRef) {
                ServerRef serverRef = (ServerRef)object;
                if (remote instanceof UnicastRemoteObject) {
                    ((UnicastRemoteObject)remote).ref = serverRef;
                }
                return serverRef.exportObject(remote, null);
            }
            throw new ExportException("Reference is not a java.rmi.server.ServerRef");
        }
        catch (Exception exception) {
            throw new ExportException("Unable to create remote reference", exception);
        }
    }
}

